﻿using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class MapToProGroupCancelRequestStep:FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            state.ProEcRequest = CancelAppointmentMapper.CancelAppointmentRequest(state, Side.Provider, Logger.Instance);

            if (!string.IsNullOrEmpty(state.ProUserDuz))
                state.ProEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = state.ProUserDuz;
            else
            {
                var siteNum = state.ProEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_loginSiteCode;
                state.ProLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SamlToken);
            }
        }
    }
}
